package net.ximpel.events
{
	import flash.events.Event;

		/**
		* A generic media type event class.
		*
		*/
	
	public class MediaEvent extends Event
	{
		public var mediaType:String;
		public var leadsto:String;
		//added duration property
		public var mediaItemDuration:Number;
		
		/**
		* Defines the value of the type property of a complete event object.
		*
		*  @eventType complete
		*/
		public static const COMPLETE:String = "complete";
		//added player READY variable for playable custom media types (video)
		public static const READY:String = "ready";
		//added player PLAYING variable for playable custom media types (video)
		public static const PLAYING:String = "ready";
		//added player BUFFERING variable for custom media types
		public static const BUFFERING:String = "buffering";
		
		/**
		 *  Constructor.
		 *
		 *  @param type The event type; indicates the action that caused the event.
		 *
		 *  @param bubbles Specifies whether the event can bubble up the display list hierarchy.
		 *
		 *  @param cancelable Specifies whether the behavior associated with 
		 *  the event can be prevented.
		 *
		 */
		public function MediaEvent(type:String, bubbles:Boolean = false,
						   cancelable:Boolean = false, mediaType:String = "", 
						   leadsto:String = "", mediaItemDuration:Number = -1)
		{
			super(type);
			this.mediaType = mediaType;
			this.leadsto = leadsto;
			this.mediaItemDuration = mediaItemDuration;
		}
		
		override public function clone():Event
		{
			return new MediaEvent(type, bubbles, cancelable, mediaType, leadsto, mediaItemDuration);
		}
	}
}