package net.ximpel.events
{
	import flash.events.Event;

	public class ScoreEvent extends Event
	{
	
		public var score:String;

		/**
		* Defines the value of the type property of a scoreChanged event object.
		*
		*  @eventType scoreChanged
		*/
		public static const SCORE_CHANGED:String = "scoreChanged";
		
		/**
		 *  Constructor.
		 *
		 *  @param type The event type; indicates the action that caused the event.
		 *
		 *  @param bubbles Specifies whether the event can bubble up the display list hierarchy.
		 *
		 *  @param cancelable Specifies whether the behavior associated with 
		 *  the event can be prevented.
		 *
		 * @param score The new score.
		 */
		public function ScoreEvent(type:String, bubbles:Boolean = false, cancelable:Boolean = false, score:String = "")
		{
			super(type);
			this.score = score;
		}
		
		override public function clone():Event
		{
			return new ScoreEvent(type, bubbles, cancelable, score);
		}
	}
}