package net.ximpel.events
{
	import flash.events.Event;

	public class SubjectEvent extends Event
	{
	
		public var subjectId:String;
		public var subjectDescription:String;

		/**
		* Defines the value of the type property of a subjectChanged event object.
		*
		*  @eventType subjectChanged
		*/
		public static const SUBJECT_CHANGED:String = "subjectChanged";
		
		/**
		 *  Constructor.
		 *
		 *  @param type The event type; indicates the action that caused the event.
		 *
		 *  @param bubbles Specifies whether the event can bubble up the display list hierarchy.
		 *
		 *  @param cancelable Specifies whether the behavior associated with 
		 *  the event can be prevented.
		 *
		 * @param score The new subject.
		 */
		public function SubjectEvent(type:String, bubbles:Boolean = false, cancelable:Boolean = false, 
									 subjectId:String = "", subjectDescription:String = "")
		{
			super(type);
			this.subjectId = subjectId;
			this.subjectDescription = subjectDescription;
		}
		
		override public function clone():Event
		{
			return new SubjectEvent(type, bubbles, cancelable, subjectId, subjectDescription);
		}
	}
}