package net.ximpel.events
{
	import flash.events.Event;

	public class XimpelEvent extends Event
	{
		/**
		* Defines the value of the type property of a playlistLoaded event object.
		*
		*  @eventType complete
		*/
		public static const PLAYLIST_LOADED:String = "playlistLoaded";
	
		/**
		* Defines the value of the type property of a complete event object.
		*
		*  @eventType complete
		*/
		public static const COMPLETE:String = "complete";
		
		/**
		* Defines the value of the type property of a nextItem event object.
		*
		*  @eventType nextItem
		*/
		public static const NEXT_ITEM:String = "nextItem";
		
		/**
		* Defines the value of the type property of a pause event object.
		*
		*  @eventType pause
		*/
		public static const PAUSE:String = "pause";
		
		/**
		* Defines the value of the type property of a previousItem event object.
		*
		*  @eventType previousItem
		*/
		public static const PREVIOUS_ITEM:String = "previousItem";
		
		/**
		* Defines the value of the type property of a resume event object.
		*
		*  @eventType resume
		*/
		public static const RESUME:String = "resume";
		
		/**
		 *  Constructor.
		 *
		 *  @param type The event type; indicates the action that caused the event.
		 *
		 *  @param bubbles Specifies whether the event can bubble up the display list hierarchy.
		 *
		 *  @param cancelable Specifies whether the behavior associated with 
		 *  the event can be prevented.
		 *
		 */
		public function XimpelEvent(type:String, bubbles:Boolean = false,
						   cancelable:Boolean = false)
		{
			super(type);
		}
		
		override public function clone():Event
		{
			return new XimpelEvent(type, bubbles, cancelable);
		}
	}
}