package net.ximpel.media
{

	import mx.core.IUIComponent;

	public interface IMediaType extends IUIComponent
	{
	
		function get typeName():String;
		
		/**
		* Plays media.
		*
		*  @param mediaData XML data given that can be used for playing the media
		*
		* @return <code>true</code> if playing the media is succesful;
		*  <code>false</code> otherwise.
		*/
		function playMedia(mediaData:XML):Boolean;
		
		function togglePauseMedia():void;

		/**
		* Stops media.
		*
		* @return <code>true</code> if stopping the media is succesful;
		*  <code>false</code> otherwise.
		*/		
		function stopMedia():Boolean;
	
	}
	
}