package net.ximpel.objects {

	import flash.events.Event;
	import mx.controls.VideoDisplay;
	import mx.core.mx_internal;
 
	use namespace mx_internal;
 
	/**
	 * Dispatched when the &lt;code&gt;smoothing&lt;/code&gt; property
	 * changes.
	 */	

	[Event(name="smoothingChanged",type="flash.events.Event")]
 
	/**
	 * VideoDisplay mutation that fixes some of the original components flaws.
	 * @author danielwilliams
	 * 
	 */	

	public class SmoothVideo extends VideoDisplay {

		/**
	 	* @private
	 	* 
	 	* A workaround for the weird VideoDisplay bug, this replaces
	 	* VideoDisplay's _autoPlay property.
	 	*/		

		private var _customAutoPlay:Boolean = true;
	
		/**
		 * @private
		 * 
		 * Internal storage for &lt;code>smoothing&lt;/code&gt; to be applied on the
		 * instance of &lt;code&gt;VideoPlayer&lt;/code&gt;. 
		 */		

		private var _smoothing:Boolean;
 
		/**
		 * @private
		 * 
		 * Flag indicating that the &lt;code&gt;smoothing&lt;/code&gt; property has changed.
		 */

		private var smoothingChanged:Boolean;
 
		/**
		 * Constructor 
		 * 
		 */		

		public function SmoothVideo() {
			super();
			// damn you, broken autoplay.
			super.autoPlay = false;
		}
 
		[Inspectable]

		[Bindable("smoothingChanged")]

		/**
		 * Allows you to choose between performance and the pretty.
		 * @return Boolean
		 * 
		 */		

		public function get smoothing():Boolean{ return _smoothing; }

		public function set smoothing( value:Boolean ):void {
			if( _smoothing != value ) {
				_smoothing = value ;
				smoothingChanged = true;
				invalidateProperties();
				dispatchEvent( new Event("smoothingChanged") );
			}
		}

		[Bindable]

		/**
		 * @inheritDoc
		 * @return 
		 * 
		 */		

		override public function get source():String {
			return super.source;
		}
 
		override public function set source(value:String):void {
			super.source = value;
			if( _customAutoPlay ) play();
		}
 
		[Inspectable(category="General", defaultValue="true")]

		/**
		 * @inheritDoc
		 * 
		 */		

		override public function get autoPlay():Boolean {
			return _customAutoPlay;
		}

 
		override public function set autoPlay(value:Boolean):void {
			_customAutoPlay = value;
		}

		/**
		 * @inheritDoc 
		 * 
		 */		

		override protected function commitProperties():void {
			super.commitProperties();
			
			if( smoothingChanged ) {
				if( mx_internal::videoPlayer != null ) {
					smoothingChanged = false ;
					mx_internal::videoPlayer.smoothing = _smoothing ;
				}
			}
		}
	}
}