package net.ximpel.score
{
	/**
	* @private
	*/
	
	public class ScoreManager {
		private var _scoreManager:Array;//Two-dimensional array containing scoreArrays
		private var _scoreTypes:Array;//Array containing type names of scoreArrays
		private var _scoreState:int;//Number of items in each scoreArray
		
		public function ScoreManager():void {
			_scoreManager = new Array();
			_scoreTypes = new Array();
			_scoreState = 1;
		}
/*		
		private function traceScores():void {
			trace("s:"+String(getScoreByName("subject"))+" b:"+String(getScoreByName("bonus"))+" t:"+String(totalScore()));
		}
*/		
		public function get numScoreTypes():int {
			return _scoreManager.length;//should always be equal to _scoreTypes.length
		}
		
		public function get scoreState():int {
			//trace("scorestate:"+String(_scoreState));
			return _scoreState;
		}
		
		/**
		 *  Returns index of existing score type; otherwise returns -1.
		 */
		private function getScoreTypeIndex(scoreTypeName:String):int {
			return _scoreTypes.indexOf(scoreTypeName);
		}
		
		public function updateScore(scoreTypeName:String, value:Number):void {
			var scoreTypeIndex:int = getScoreTypeIndex(scoreTypeName);
			if(scoreTypeIndex > -1) {
				var scoreArray:Array = _scoreManager[scoreTypeIndex];
				scoreArray[scoreArray.length-1] += value;
				//trace("upd exist. "+scoreArray.toString());
			} else {
				_scoreTypes.push(scoreTypeName);
				var newScoreArray:Array = new Array(scoreState);
				for (var i:int = 0; i < scoreState; i++) {
					newScoreArray[i] = 0;
				}
				newScoreArray[scoreState - 1] = value;
				_scoreManager.push(newScoreArray);
				//trace("upd new"+newScoreArray.toString());
			}
		}

		public function advanceScoreState():void {
			//trace("scorestate:"+String(_scoreState));
			for (var i:int = 0; i < numScoreTypes; i++) {
				_scoreManager[i].push(0);
				//trace("adv"+String(i)+": "+_scoreManager[i].toString() + " - length:" + String(_scoreManager[i].length));
			}
			_scoreState++;
		}
		
		public function rollBackScoreState():void {
			if(scoreState > 1){//There must always be one element for each scoreArray
				for (var i:int = 0; i < numScoreTypes; i++) {
					_scoreManager[i].pop();
					//trace("rb1+"+String(i)+": "+_scoreManager[i].toString() + " - length:" + String(_scoreManager[i].length));
				}
				_scoreState--;
			}else if (scoreState == 1) {//Clear the only element for each scoreArray
				for (var j:int = 0; j < numScoreTypes; j++) {
					_scoreManager[j][0] = 0;
					//trace("rb1"+String(j)+": "+_scoreManager[j].toString() + " - length:" + String(_scoreManager[j].length));
				}
			}
		}
		
		public function getCurrentScoreStateByName(scoreTypeName:String):Number {
			var scoreTypeIndex:int = getScoreTypeIndex(scoreTypeName);
			if(scoreTypeIndex > -1) {
				return _scoreManager[scoreTypeIndex][scoreState - 1];
			}else {
				return 0;
			}
		}
		
		public function clearCurrentScoreStateByName(scoreTypeName:String):void {
			var scoreTypeIndex:int = getScoreTypeIndex(scoreTypeName);
			if(scoreTypeIndex > -1) {
				_scoreManager[scoreTypeIndex][scoreState - 1] = 0;
			}
		}
		
		public function clearCurrentScoreStates():void {
			for (var i:int = 0; i < numScoreTypes; i++) {
				_scoreManager[i][scoreState - 1] = 0;
			}
		}
		
		public function getScoreByName(scoreTypeName:String):Number {
			var scoreTypeIndex:int = getScoreTypeIndex(scoreTypeName);
			if(scoreTypeIndex > -1) {
				var score:Number = 0;
				var scoreArray:Array = _scoreManager[scoreTypeIndex];
				for (var i:int = 0; i < scoreArray.length; i++){
					score += scoreArray[i];
				}
				//trace(scoreTypeName,String(score));
				return score;
			} else {
				return 0;//Type does not exist (yet), so score is automatically 0
			}
		}
		
		public function getScoreArrayByName(scoreTypeName:String):Array {
			var scoreTypeIndex:int = getScoreTypeIndex(scoreTypeName);
			if(scoreTypeIndex > -1) {
				var copy:Array = _scoreManager[scoreTypeIndex].concat();
				return copy;
			} else {
				return [0];
			}
		}
		
		public function totalScore():Number {
			var score:Number = 0;
			for (var i:int = 0; i < numScoreTypes; i++) {
				score += getScoreByName(_scoreTypes[i]);
			}
			//trace("total",String(score));
			return score;
		}
	}
}